/*
 * Copyright (C) tfs, 2007
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 */


#include "stdafx.h"
#include <usp10.h>

#include "UnisSample.h"
#include "ChildView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

#define COMPILE_VER 3

// CChildView

CChildView::CChildView()
{
}

CChildView::~CChildView()
{
}


BEGIN_MESSAGE_MAP(CChildView, CWnd)
	ON_WM_PAINT()
    ON_COMMAND(ID_VIEW_JP78, OnViewJp78)
    ON_COMMAND(ID_VIEW_JP83, OnViewJp83)
    ON_COMMAND(ID_VIEW_JP90, OnViewJp90)
    ON_COMMAND(ID_VIEW_JP04, OnViewJp04)
    ON_UPDATE_COMMAND_UI(ID_VIEW_JP78, OnUpdateViewJp78)
    ON_UPDATE_COMMAND_UI(ID_VIEW_JP83, OnUpdateViewJp83)
    ON_UPDATE_COMMAND_UI(ID_VIEW_JP90, OnUpdateViewJp90)
    ON_UPDATE_COMMAND_UI(ID_VIEW_JP04, OnUpdateViewJp04)
    ON_COMMAND(ID_VIEW_FONT, OnViewFont)
END_MESSAGE_MAP()

/*
 *
 */

BOOL CChildView::PreCreateWindow(CREATESTRUCT& cs) 
{
	if (!CWnd::PreCreateWindow(cs))
		return FALSE;

	cs.dwExStyle |= WS_EX_CLIENTEDGE;
	cs.style &= ~WS_BORDER;
	cs.lpszClass = AfxRegisterWndClass(CS_HREDRAW|CS_VREDRAW|CS_DBLCLKS, 
		::LoadCursor(NULL, IDC_ARROW), reinterpret_cast<HBRUSH>(COLOR_WINDOW+1), NULL);

    md = ID_VIEW_JP04;

    memset(&lf, '\0', sizeof(lf));
    strcpy(lf.lfFaceName, _T("MS Gothic"));
    lf.lfHeight = -14;

	return TRUE;
}

/*
 *  Verion 1
 *    Using ScriptStringXxxx.
 *    feature tag is unavilable.
 */
#if COMPILE_VER == 1
void CChildView::OnPaint() 
{
	CPaintDC dc(this);

    SCRIPT_STRING_ANALYSIS ssa;
    int x = 0, y = 0;
    RECT rct = {0, 0, 100, 100};
    HRESULT rslt;
    const char *str = "ABCDEFG";
    int len = strlen(str);

    rslt = ScriptStringAnalyse(
        dc.m_hDC,
        str, len,
        2 * len + 16,
        DEFAULT_CHARSET,
        SSA_GLYPHS|SSA_LINK,
        0,
        NULL, // control
        NULL, // state
        NULL, // piDx
        NULL,
        NULL, // pbInClass
        &ssa);

    rslt = ScriptStringOut(
        ssa, x, y, 0,//ETO_OPAQUE
        &rct,
        0, 0, FALSE);

	ScriptStringFree(&ssa);
}
#endif

/*
 * Version 2
 *   Using ScriptXxxxx
 *   Still not using feature tag
 */
#if COMPILE_VER == 2
void CChildView::OnPaint() 
{
	CPaintDC dc(this);
    CFont ff;

//    ff.CreatePointFont(120, _T("MS Gothic"), NULL);
    ff.CreateFontIndirect(&lf);
    dc.SelectObject(ff);


    HRESULT rslt;
    const  WCHAR *str = L"ABCDEFG";
//    const  WCHAR *str = L"ABCDEFG";
    int len = (int)wcslen(str);

    const SCRIPT_CONTROL *psControl = NULL;
    const SCRIPT_STATE *psState = NULL;
    int cMaxItems = 500;
    SCRIPT_ITEM items[500];
    int cItems;

    if (0) {
        // It does not seem these are required.
        SCRIPT_DIGITSUBSTITUTE sds = {0};
        SCRIPT_CONTROL sc = {0};
        SCRIPT_STATE   ss = {0};

        rslt = ScriptRecordDigitSubstitution(LOCALE_USER_DEFAULT, &sds);
        ScriptApplyDigitSubstitution(&sds, &sc, &ss);
    }

    /* Itemize */
    rslt = ScriptItemize(
        str, len, 
        cMaxItems, 
        psControl, psState,
        items, &cItems);

    SCRIPT_CACHE ssc = NULL;
    int dx=0, dy=0;

    for (int i=0; i<cItems; i++) {
        int idx = items[i].iCharPos;
        int lll = items[i+1].iCharPos - idx;
        int mx_glyph = lll * 2 + 16;
        int glyph_cnt = 0;

        WORD *clusts = (WORD*)malloc(sizeof(WORD)*mx_glyph);
        WORD *glyphs = (WORD*)malloc(sizeof(WORD)*mx_glyph);
        SCRIPT_VISATTR *sva = 
            (SCRIPT_VISATTR*)malloc(sizeof(SCRIPT_VISATTR)*mx_glyph);
        int *adv = NULL;
        GOFFSET *offs = NULL;

        /* Shape */
        rslt = ScriptShape(
                    dc.m_hDC, &ssc, str+idx, lll, mx_glyph,
                    &items[i].a, glyphs, clusts, sva, &glyph_cnt);
        if (SUCCEEDED(rslt) == FALSE) goto clean;

        //XXX
        //OPENTYPE_TAG tag1 = 'j' | ('p' << 8) | ('9' << 16) | ('0' << 24);
        //rslt = ScriptShapeOpenType(
        //            dc.m_hDC, &ssc, &items[i],
        //            tagScript, tagLangSys, rcRangeChars, rpRangeProp, cRange,
        //            str+idx, lll, mx_glyph,
        //            clusts, charProp, glyphs, outGlyph, &glyph_cnt);     

        ABC abc;
        offs = (GOFFSET*)malloc(sizeof(GOFFSET)*mx_glyph);
        adv = (int*)malloc(sizeof(int)*mx_glyph);

        /* Place */
        rslt = ScriptPlace(
                    dc.m_hDC, &ssc, glyphs, glyph_cnt, sva, &items[i].a, 
                    adv, offs, &abc);
        if (SUCCEEDED(rslt) == FALSE) goto clean;

        /* TextOut */
        rslt = ScriptTextOut(
                    dc.m_hDC, &ssc, dx, dy, 0/*ETO_CLIPPED*/, NULL/*&lprc*/, 
                    &items[i].a, NULL, 0,
                    glyphs, glyph_cnt, adv, 
                    NULL, //const int *piJustify
                    offs);
        dx += abc.abcA + abc.abcB + abc.abcC;

      clean:
        free(clusts);
        free(glyphs);
        free(sva);
        free(adv);
        if (SUCCEEDED(rslt) == FALSE) break;
    }

    ScriptFreeCache(&ssc);
}
#endif

/*
 * Version 3
 *   Using ScriptXxxxxOpenType
 *   usp10.dll 1.600 or later is required.
 *
 *   I have not found header file about usp10.lib of 1.600 yet,
 *   so write declaration at local.
 *
 *   Using GetProcAddress() for 1.600 only function.
 *   (So work on XP, but its result is not what is expected.)
 *   Also check lf and md member, and change behaviour.
 */
#if COMPILE_VER == 3

typedef ULONG OPENTYPE_TAG;
typedef struct opentype_feature_record{
  OPENTYPE_TAG  tagFeature;
  LONG  lParameter;
} OPENTYPE_FEATURE_RECORD;
typedef struct textrange_properties{
    OPENTYPE_FEATURE_RECORD*   potfRecords;
    int cotfRecords;
} TEXTRANGE_PROPERTIES;
typedef struct script_charprop{
    WORD           fCanGlyphAlone : 1;
    WORD           reserved       : 15; 
} SCRIPT_CHARPROP;
typedef struct script_glyphprop { 
    SCRIPT_VISATTR sva;
    WORD reserved;
} SCRIPT_GLYPHPROP;

typedef HRESULT (*TScriptItemizeOpenType)(
  const WCHAR* pwcInChars,
  int cInChars,
  int cMaxItems,
  const SCRIPT_CONTROL* psControl,
  const SCRIPT_STATE* psState,
  SCRIPT_ITEM* pItems,
  OPENTYPE_TAG* pScriptTags,
  int* pcItems 
  );
typedef HRESULT (*TScriptShapeOpenType)(
  HDC hdc,
  SCRIPT_CACHE* psc,
  SCRIPT_ANALYSIS* psa,
  OPENTYPE_TAG tagScript,
  OPENTYPE_TAG tagLangSys,
  int* rcRangeChars,
  TEXTRANGE_PROPERTIES** rpRangeProperties,
  int cRanges,
  const WCHAR* pwcChars,
  int cChars,
  int cMaxGlyphs,
  WORD* pwLogClust,
  SCRIPT_CHARPROP* pCharProps,
  WORD* pwOutGlyphs,
  SCRIPT_GLYPHPROP* pOutGlyphProps,
  int* pcGlyphs
);
typedef HRESULT (*TScriptPlaceOpenType)(
  HDC hdc,
  SCRIPT_CACHE* psc,
  SCRIPT_ANALYSIS* psa,
  OPENTYPE_TAG tagScript,
  OPENTYPE_TAG tagLangSys,
  int* rcRangeChars,
  TEXTRANGE_PROPERTIES** rpRangeProperties,
  int cRanges,
  const WCHAR* pwcChars,
  const WORD* pwLogClust,
  const SCRIPT_CHARPROP* pCharProps,
  int cChars,
  const WORD* pwGlyphs,
  const SCRIPT_GLYPHPROP* pGlyphProps,
  int cGlyphs,
  int* piAdvance,
  GOFFSET* pGoffset,
  ABC* pABC
);


void CChildView::OnPaint() 
{
	CPaintDC dc(this);
    CFont ff;

    /* Font for drawing */
    ff.CreateFontIndirect(&lf);
    dc.SelectObject(ff);

    /* Load DLL */
    HMODULE dll = GetModuleHandle("usp10.dll");
    if (dll == NULL) {
        return;
    }

    TScriptItemizeOpenType f_itemize = 
		(TScriptItemizeOpenType)GetProcAddress(dll, "ScriptItemizeOpenType");
    TScriptShapeOpenType   f_shape =
        (TScriptShapeOpenType)GetProcAddress(dll, "ScriptShapeOpenType");
    TScriptPlaceOpenType f_place   =
        (TScriptPlaceOpenType)GetProcAddress(dll, "ScriptPlaceOpenType");

    if (f_itemize == NULL ||
        f_shape == NULL ||
        f_place == NULL) return;

    HRESULT rslt;
    // sample text
    const  WCHAR *str = L"ABCDEFG\\IXӌJFFڑHMߌTN[}";
//    const  WCHAR *str = L"ABCDEFG";
    int len = (int)wcslen(str);

    const SCRIPT_CONTROL *psControl = NULL;
    const SCRIPT_STATE *psState = NULL;
    int cMaxItems = 500;
    SCRIPT_ITEM items[500];
    int cItems;

    if (0) {
        // It does not seem these are required.
        SCRIPT_DIGITSUBSTITUTE sds = {0};
        SCRIPT_CONTROL sc = {0};
        SCRIPT_STATE   ss = {0};

        rslt = ScriptRecordDigitSubstitution(LOCALE_USER_DEFAULT, &sds);
        ScriptApplyDigitSubstitution(&sds, &sc, &ss);
    }

    /* Itemize */
	OPENTYPE_TAG *scrpt =
                    (OPENTYPE_TAG*)malloc(sizeof(OPENTYPE_TAG)*len);

    rslt = f_itemize(
        str, len, 
        cMaxItems, 
        psControl, psState,
        items, scrpt, &cItems);

    SCRIPT_CACHE ssc = NULL;
    int dx=0, dy=0;

    for (int i=0; i<cItems; i++) {
        int idx = items[i].iCharPos;         // Start position of item i
        int lll = items[i+1].iCharPos - idx; // The number of char in the item
        int mx_glyph = lll * 2 + 16;         // Max glyph. Error check required.
                                             // 
        int glyph_cnt = 0;

        WORD *clusts = (WORD*)malloc(sizeof(WORD)*mx_glyph);
        WORD *glyphs = (WORD*)malloc(sizeof(WORD)*mx_glyph);
//        SCRIPT_VISATTR *sva = 
//            (SCRIPT_VISATTR*)malloc(sizeof(SCRIPT_VISATTR)*mx_glyph);
        int *adv = NULL;
        GOFFSET *offs = NULL;

        /* Set Tag */
        OPENTYPE_TAG tag78 = 'j' | ('p' << 8) | ('7' << 16) | ('8' << 24);
        OPENTYPE_TAG tag83 = 'j' | ('p' << 8) | ('8' << 16) | ('3' << 24);
        OPENTYPE_TAG tag90 = 'j' | ('p' << 8) | ('9' << 16) | ('0' << 24);
        OPENTYPE_TAG tag04 = 'j' | ('p' << 8) | ('0' << 16) | ('4' << 24);
        OPENTYPE_FEATURE_RECORD rcd;
        TEXTRANGE_PROPERTIES *prop, pp; prop = &pp;

        SCRIPT_CHARPROP *charProp = 
                (SCRIPT_CHARPROP*)malloc(sizeof(SCRIPT_CHARPROP)*lll);
        SCRIPT_GLYPHPROP *glyhProp =
                (SCRIPT_GLYPHPROP*)malloc(sizeof(SCRIPT_GLYPHPROP)*lll);
        int *range = (int*)malloc(sizeof(int)*lll);
        for (int kk=0;kk<lll;kk++) range[kk] = 0;

        rcd.tagFeature = tag04;
        rcd.lParameter = 1;
        pp.potfRecords = &rcd;
        pp.cotfRecords = 1;

        switch (md) {
        case ID_VIEW_JP78: rcd.tagFeature = tag78; break;
        case ID_VIEW_JP83: rcd.tagFeature = tag83; break;
        case ID_VIEW_JP90: rcd.tagFeature = tag90; break;
        case ID_VIEW_JP04: rcd.tagFeature = tag04; break;
        }

        /* Shape */
        rslt = f_shape(
                    dc.m_hDC, &ssc, &items[i].a,
                    scrpt[i], 0, &lll, &prop, 1,
                    str+idx, lll, mx_glyph,
                    clusts, charProp, glyphs, glyhProp, &glyph_cnt);
        if (SUCCEEDED(rslt) == FALSE) goto clean;

        ABC abc;
        offs = (GOFFSET*)malloc(sizeof(GOFFSET)*mx_glyph);
        adv = (int*)malloc(sizeof(int)*mx_glyph);

        /* Place */
        rslt = f_place(
                    dc.m_hDC, &ssc, &items[i].a, 
                    scrpt[i], 0, &lll, &prop, 1,
                    str+idx, clusts, charProp, lll, glyphs, glyhProp, glyph_cnt,
                    /*sva,*/
                    adv, offs, &abc);
        if (SUCCEEDED(rslt) == FALSE) goto clean;

        /* TextOut */
        rslt = ScriptTextOut(
                    dc.m_hDC, &ssc, dx, dy, 0/*ETO_CLIPPED*/, NULL/*&lprc*/, 
                    &items[i].a, NULL, 0,
                    glyphs, glyph_cnt, adv, 
                    NULL, //const int *piJustify
                    offs);
        dx += abc.abcA + abc.abcB + abc.abcC;

      clean:
        free(clusts);
        free(glyphs);
//        free(sva);
        free(adv);
        free(charProp);
        free(glyhProp);
        free(range);
        if (SUCCEEDED(rslt) == FALSE) break;
    }

    free(scrpt);
    ScriptFreeCache(&ssc);
}
#endif
/* --------------------------------------------------------
 * User Interface Callback
 * -------------------------------------------------------- */

/*
 * Callback of tag selection
 */
void CChildView::OnViewJp78()
{
    md = ID_VIEW_JP78;
    Invalidate();
}
void CChildView::OnViewJp83()
{
    md = ID_VIEW_JP83;
    Invalidate();
}
void CChildView::OnViewJp90()
{
    md = ID_VIEW_JP90;
    Invalidate();
}
void CChildView::OnViewJp04()
{
    md = ID_VIEW_JP04;
    Invalidate();
}

void CChildView::OnUpdateViewJp04(CCmdUI *pCmdUI)
{ pCmdUI->SetCheck((md == ID_VIEW_JP04)); }
void CChildView::OnUpdateViewJp90(CCmdUI *pCmdUI)
{ pCmdUI->SetCheck((md == ID_VIEW_JP90)); }
void CChildView::OnUpdateViewJp83(CCmdUI *pCmdUI)
{ pCmdUI->SetCheck((md == ID_VIEW_JP83)); }
void CChildView::OnUpdateViewJp78(CCmdUI *pCmdUI)
{ pCmdUI->SetCheck((md == ID_VIEW_JP78)); }

/*
 * Callback of font selectoin
 */
void CChildView::OnViewFont()
{
    CFontDialog dlg;
    dlg.m_cf.Flags |= CF_INITTOLOGFONTSTRUCT;
    dlg.m_cf.lpLogFont = &lf;
    if (dlg.DoModal() != IDOK) return;
    lf = dlg.m_lf;
    Invalidate();
}
